/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.IPlantable;

public class FertileSoil
extends Block {
    private final BlockState plant;
    private final SeedCategory category;

    protected FertileSoil(String plantName, BlockState plant, SeedCategory category) {
        super(BlockBehaviour.Properties.m_60939_((Material)(category == SeedCategory.HELL_CROP ? Material.f_76317_ : Material.f_76314_)).m_60978_(0.5f).m_60918_(SoundType.f_56739_).m_60977_());
        this.plant = plant;
        this.category = category;
        String name = "fertile_soil_" + plantName;
        this.setRegistryName(name);
        ESBlocks.toRegister.add(this);
        ESBlocks.blockAddQue(this);
    }

    public List<ItemStack> m_7381_(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return super.m_7381_(p_220076_1_, p_220076_2_);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)new TranslatableComponent("tt.essentials.fertile_soil.desc"));
        tooltip.add((Component)new TranslatableComponent("tt.essentials.fertile_soil.benefits"));
        if (this.category == SeedCategory.HELL_CROP) {
            tooltip.add((Component)new TranslatableComponent("tt.essentials.fertile_soil.quip").m_6270_(ESConfig.TT_QUIP));
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, IPlantable plantable) {
        return this.plant.m_60734_() == plantable;
    }

    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if ((Double)ESConfig.fertileSoilRate.get() < 100.0 * Math.random()) {
            return;
        }
        BlockPos upPos = pos.m_142300_(Direction.UP);
        if (worldIn.m_46859_(upPos) && (this.category != SeedCategory.CROP || worldIn.m_45524_(upPos, 0) > 7)) {
            worldIn.m_46597_(upPos, this.plant);
        }
    }

    public static enum SeedCategory {
        CROP,
        TREE,
        HELL_CROP,
        BERRY,
        MUSHROOM;

    }
}

